/*
 *
 *  Copyright 2010-Present Peregrine Labs. All rights reserved.
 *  (c) 2010-Present Peregrine Labs a division of Peregrine Visual Storytelling Ltd.
 *  All rights reserved.
 *
 *  The coded instructions, statements, computer programs, and/or related
 *  material (collectively the "Data") in these files contain unpublished
 *  information proprietary to Peregrine Visual Storytelling Ltd. ("Peregrine")
 *  and/or its licensors, which is protected by U.S. and Canadian federal
 *  copyright law and by international treaties.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. PEREGRINE
 *  DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTIES
 *  INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF NON-INFRINGEMENT,
 *  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR ARISING FROM A COURSE
 *  OF DEALING, USAGE, OR TRADE PRACTICE. IN NO EVENT WILL PEREGRINE AND/OR ITS
 *  LICENSORS BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL,
 *  DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF PEREGRINE AND/OR ITS
 *  LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
 *
 *
 */

#ifndef YETI_GRAPHEXECUTION_H
#define YETI_GRAPHEXECUTION_H

#include <vector>

#include "Common.h"
#include "ExecutionResult.h"
#include "Graph.h"

YETI_NS_BEGIN

struct GraphExecutionOptions
{
    float density = 1.0f;
    float length = 1.0f;
    float width = 1.0f;
    int verbosity = 0;
    bool expandFeathers = true;
    bool requiresUVW = false;
    bool useROI = false;
    BoxType roi = {};
    std::string imageSearchPath;
    std::string owner;
    std::string name;
    int additionalEndKnots = 0;
    bool supportsInstances = false;
    VaryingInterpolationType varyingInterpolation = VaryingInterpolationType::PerVertex;
    std::vector<std::string> reservedAttributes = {};
};

YETI_EXPORT std::shared_ptr<ExecutionResult> executeGraph(const std::shared_ptr<Graph> &graph,
        const std::vector<float> &sampleTimes,
        const GraphExecutionOptions &options);

YETI_NS_END

#endif // YETI_GRAPHEXECUTION_H
