/*
 *
 *  Copyright 2010-Present Peregrine Labs. All rights reserved.
 *  (c) 2010-Present Peregrine Labs a division of Peregrine Visual Storytelling Ltd.
 *  All rights reserved.
 *
 *  The coded instructions, statements, computer programs, and/or related
 *  material (collectively the "Data") in these files contain unpublished
 *  information proprietary to Peregrine Visual Storytelling Ltd. ("Peregrine")
 *  and/or its licensors, which is protected by U.S. and Canadian federal
 *  copyright law and by international treaties.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. PEREGRINE
 *  DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTIES
 *  INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF NON-INFRINGEMENT,
 *  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR ARISING FROM A COURSE
 *  OF DEALING, USAGE, OR TRADE PRACTICE. IN NO EVENT WILL PEREGRINE AND/OR ITS
 *  LICENSORS BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL,
 *  DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF PEREGRINE AND/OR ITS
 *  LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
 *
 *
 */

#ifndef YETI_GEOOBJECT_H
#define YETI_GEOOBJECT_H

#include <memory>
#include "Common.h"
#include "AttributeContainer.h"

YETI_NS_BEGIN

class YETI_EXPORT GeoObject
{
public:
    virtual std::string uuid() const = 0;
    virtual int objectID() const = 0;
    virtual std::string name() const = 0;
    virtual GeometryType geometryType() const = 0;
    virtual std::shared_ptr<AttributeContainer> attributes() const = 0;
    virtual BoxType boundingBox(bool worldSpace) const = 0;
    virtual MatrixType xform() const = 0;
    virtual bool hasXform() const = 0;
    virtual int attributeDetailCount(DetailType detailType) const = 0;
    virtual int getMetaDataInt(const std::string &key, int defaultValue) const = 0;
    virtual bool getMetaDataBoolean(const std::string &key, bool defaultValue) const = 0;
    virtual float getMetaDataFloat(const std::string &key, float defaultValue) const = 0;
    virtual VectorType getMetaDataVector(const std::string &key, VectorType defaultValue) const = 0;
    virtual std::string getMetaDataString(const std::string &key, const std::string &defaultValue) const = 0;
};

YETI_NS_END

#endif // YETI_GEOOBJECT_H
