/*
 *
 *  Copyright 2010-Present Peregrine Labs. All rights reserved.
 *  (c) 2010-Present Peregrine Labs a division of Peregrine Visual Storytelling Ltd.
 *  All rights reserved.
 *
 *  The coded instructions, statements, computer programs, and/or related
 *  material (collectively the "Data") in these files contain unpublished
 *  information proprietary to Peregrine Visual Storytelling Ltd. ("Peregrine")
 *  and/or its licensors, which is protected by U.S. and Canadian federal
 *  copyright law and by international treaties.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. PEREGRINE
 *  DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTIES
 *  INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF NON-INFRINGEMENT,
 *  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR ARISING FROM A COURSE
 *  OF DEALING, USAGE, OR TRADE PRACTICE. IN NO EVENT WILL PEREGRINE AND/OR ITS
 *  LICENSORS BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL,
 *  DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF PEREGRINE AND/OR ITS
 *  LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
 *
 *
 */

#ifndef YETI_TYPES_H
#define YETI_TYPES_H

#include <cstring>

#include "Common.h"

YETI_NS_BEGIN

struct Vector3
{
    float x, y, z;
};

inline bool operator==(const Vector3 &lhs, const Vector3 &rhs)
{
    return memcmp(&lhs, &rhs, sizeof(Vector3)) == 0;
}

inline bool operator!=(const Vector3 &lhs, const Vector3 &rhs)
{
    return !(rhs == lhs);
}

struct Color3
{
    float x, y, z;
};

inline bool operator==(const Color3 &lhs, const Color3 &rhs)
{
    return memcmp(&lhs, &rhs, sizeof(Color3)) == 0;
}

inline bool operator!=(const Color3 &lhs, const Color3 &rhs)
{
    return !(rhs == lhs);
}

struct Matrix44
{
    float data[4][4];
};

inline bool operator==(const Matrix44 &lhs, const Matrix44 &rhs)
{
    return memcmp(&lhs, &rhs, sizeof(Matrix44)) == 0;
}

inline bool operator!=(const Matrix44 &lhs, const Matrix44 &rhs)
{
    return !(rhs == lhs);
}

struct Box3
{
    Vector3 min, max;
};

inline bool operator==(const Box3 &lhs, const Box3 &rhs)
{
    return memcmp(&lhs, &rhs, sizeof(Box3)) == 0;
}

inline bool operator!=(const Box3 &lhs, const Box3 &rhs)
{
    return !(rhs == lhs);
}

using IntType = int;
using FloatType = float;
using VectorType = Vector3;
using MatrixType = Matrix44;
using ColorType = Color3;
using BoxType = Box3;

enum class DataType
{
    Int = 0,
    Float,
    Vector,
    Matrix,
    Color
};

enum class DetailType
{
    Unknown = 0,
    Constant,
    Uniform,
    Vertex,
    Varying,
    Face,
    FaceVertex,
    FaceSet
};

enum class TemporalType
{
    Static = 0,
    Dynamic
};

enum class GeometryType
{
    Unknown = 0,
    Mesh,
    NurbsSurface,
    Particles,
    Fibres,
    Strands,
    SubD,
    Curves,
    Instance,
    Feather,
    Braid
};

enum class VaryingInterpolationType
{
    PerVertex = 0,
    PerSegment
};

enum AttributeFlags
{
    VertexSetFlag = 0x01,
    FaceSetFlag = 0x02,
    HiddenFlag = 0x08,
    ReformattedFlag = 0x10
};

YETI_NS_END

#endif // YETI_TYPES_H
