/*
 *
 *  Copyright 2010-Present Peregrine Labs. All rights reserved.
 *  (c) 2010-Present Peregrine Labs a division of Peregrine Visual Storytelling Ltd.
 *  All rights reserved.
 *
 *  The coded instructions, statements, computer programs, and/or related
 *  material (collectively the "Data") in these files contain unpublished
 *  information proprietary to Peregrine Visual Storytelling Ltd. ("Peregrine")
 *  and/or its licensors, which is protected by U.S. and Canadian federal
 *  copyright law and by international treaties.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. PEREGRINE
 *  DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTIES
 *  INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF NON-INFRINGEMENT,
 *  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR ARISING FROM A COURSE
 *  OF DEALING, USAGE, OR TRADE PRACTICE. IN NO EVENT WILL PEREGRINE AND/OR ITS
 *  LICENSORS BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL,
 *  DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF PEREGRINE AND/OR ITS
 *  LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
 *
 *
 */

#ifndef YETI_GEOCONTAINER_H
#define YETI_GEOCONTAINER_H

#include "GeoObject.h"
#include "Common.h"


YETI_NS_BEGIN

class YETI_EXPORT GeoContainer
{
public:
    virtual size_t memUsage() const = 0;
    virtual int numObjects() const = 0;
    virtual std::shared_ptr<GeoObject> get(int index) const = 0;
    virtual std::shared_ptr<GeoObject> get(const std::string &name) const = 0;
    virtual bool contains(const std::string &name) const = 0;
    virtual std::vector<std::string> objectNames() const = 0;
};

YETI_NS_END

#endif // YETI_GEOCONTAINER_H
