/*
 *
 *  Copyright 2010-Present Peregrine Labs. All rights reserved.
 *  (c) 2010-Present Peregrine Labs a division of Peregrine Visual Storytelling Ltd.
 *  All rights reserved.
 *
 *  The coded instructions, statements, computer programs, and/or related
 *  material (collectively the "Data") in these files contain unpublished
 *  information proprietary to Peregrine Visual Storytelling Ltd. ("Peregrine")
 *  and/or its licensors, which is protected by U.S. and Canadian federal
 *  copyright law and by international treaties.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. PEREGRINE
 *  DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTIES
 *  INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF NON-INFRINGEMENT,
 *  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR ARISING FROM A COURSE
 *  OF DEALING, USAGE, OR TRADE PRACTICE. IN NO EVENT WILL PEREGRINE AND/OR ITS
 *  LICENSORS BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL,
 *  DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF PEREGRINE AND/OR ITS
 *  LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
 *
 *
 */

#ifndef YETI_ATTRIBUTENAMES_H
#define YETI_ATTRIBUTENAMES_H

#include "Common.h"

YETI_NS_BEGIN

namespace Attributes
{
    // Common attributes
    static constexpr const char *P = "P";
    static constexpr const char *PRef = "Pundef";
    static constexpr const char *N = "N";
    static constexpr const char *NRef = "Nundef";
    static constexpr const char *U = "u";
    static constexpr const char *V = "v";
    static constexpr const char *UVW = "uvw";
    static constexpr const char *S = "s";
    static constexpr const char *T = "t";
    static constexpr const char *dU = "u";
    static constexpr const char *dV = "v";

    // Rendering attributes
    static constexpr const char *RenderPRef = "Pref";

    // Mesh attributes
    static constexpr const char *MeshNumFaceVertices = "numFaceVertices";
    static constexpr const char *MeshVertexID = "vertexId";
    static constexpr const char *MeshSubdivision = "subd";

    // Curves / fibres
    static constexpr const char *CurveNumVertices = "numVertices";
    static constexpr const char *CurveWidth = "width";

    // Feathers
    static constexpr const char *FeatherNumVertices = "numVertices";

    // Particles
    static constexpr const char *ParticleRadius = "radius";
};

YETI_NS_END

#endif // YETI_ATTRIBUTENAMES_H
