/*
 *
 *  Copyright 2010-Present Peregrine Labs. All rights reserved.
 *  (c) 2010-Present Peregrine Labs a division of Peregrine Visual Storytelling Ltd.
 *  All rights reserved.
 *
 *  The coded instructions, statements, computer programs, and/or related
 *  material (collectively the "Data") in these files contain unpublished
 *  information proprietary to Peregrine Visual Storytelling Ltd. ("Peregrine")
 *  and/or its licensors, which is protected by U.S. and Canadian federal
 *  copyright law and by international treaties.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. PEREGRINE
 *  DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTIES
 *  INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF NON-INFRINGEMENT,
 *  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR ARISING FROM A COURSE
 *  OF DEALING, USAGE, OR TRADE PRACTICE. IN NO EVENT WILL PEREGRINE AND/OR ITS
 *  LICENSORS BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL,
 *  DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF PEREGRINE AND/OR ITS
 *  LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
 *
 *
 */

#ifndef YETI_COMMON_H
#define YETI_COMMON_H

#ifndef YETI_API_VERSION
#define YETI_API_VERSION V1
#endif

#ifndef YETI_NS_PREFIX
#define YETI_NS_PREFIX Yeti
#endif

#ifndef YETI_NS
#define YETI_NS YETI_NS_PREFIX::YETI_API_VERSION
#endif

#ifndef YETI_NS_BEGIN
#define YETI_NS_BEGIN namespace YETI_NS_PREFIX { namespace YETI_API_VERSION {
#endif

#ifndef YETI_NS_END
#define YETI_NS_END } }
#endif

#if defined(YETI_DLL)
    #if defined(YETI_EXPORTS)
        #define YETI_EXPORT __declspec(dllexport)
    #else
        #define YETI_EXPORT __declspec(dllimport)
    #endif
#else
    #if defined _WIN32 || defined _WIN64
        #define YETI_EXPORT
    #else
        #define YETI_EXPORT __attribute__ ((visibility ("default")))
    #endif
#endif

#endif // YETI_COMMON_H
